/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.activityfolder.HostPortTestDialog;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTRadioButton;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.util.SCTSelection;
import com.quantumdata.std.IRemoteConnection;
import com.quantumdata.std.SerialConnection;
import com.quantumdata.std.SocketConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;

public class HostInterfacePort
extends ActivityFolder
implements ActionListener,
MouseListener {
    private SCTButton m_testButton;
    private SCTRadioButton[] m_serialCheckBoxes;
    private SCTRadioButton[] m_ethernetCheckBoxes;
    private SCTRadioButton[] m_otherCheckBoxes;
    private SCTTextField[] m_ipaddressFields;
    private Properties userProps = new Properties();

    public HostInterfacePort(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI, "Port");
        Object object;
        try {
            object = new FileInputStream("Properties.host.user");
            if (object != null) {
                this.userProps.load((InputStream)object);
                ((FileInputStream)object).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new SCTPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((Container)object).add(this.ethernetPanel());
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        sCTPanel.add((Component)object, "Center");
        sCTPanel.add((Component)this.btnPanel(), "South");
        this.add(sCTPanel);
    }

    private SCTPanel serialPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String[] stringArray = SerialConnection.getAvailablePortNames();
        this.m_serialCheckBoxes = new SCTRadioButton[stringArray.length];
        SCTLabel sCTLabel = new SCTLabel("Serial");
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        for (int i = 0; i < stringArray.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 2;
            this.m_serialCheckBoxes[i] = new SCTRadioButton(stringArray[i]);
            this.m_serialCheckBoxes[i].addMouseListener(this);
            gridBagLayout.setConstraints(this.m_serialCheckBoxes[i], gridBagConstraints);
            buttonGroup.add(this.m_serialCheckBoxes[i]);
            sCTPanel2.add(this.m_serialCheckBoxes[i]);
        }
        if (stringArray.length == 0) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            SCTLabel sCTLabel2 = new SCTLabel("No ports found.");
            gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints);
            sCTPanel2.add(sCTLabel2);
        }
        sCTPanel.add((Component)sCTPanel2, "North");
        return sCTPanel;
    }

    private SCTPanel ethernetPanel() {
        this.m_ethernetCheckBoxes = new SCTRadioButton[9];
        this.m_ipaddressFields = new SCTTextField[9];
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        SCTLabel sCTLabel = new SCTLabel("Ethernet");
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        for (int i = 0; i < this.m_ethernetCheckBoxes.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 2;
            this.m_ethernetCheckBoxes[i] = new SCTRadioButton();
            gridBagLayout.setConstraints(this.m_ethernetCheckBoxes[i], gridBagConstraints);
            buttonGroup.add(this.m_ethernetCheckBoxes[i]);
            sCTPanel2.add(this.m_ethernetCheckBoxes[i]);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i + 2;
            this.m_ipaddressFields[i] = new SCTTextField(12);
            String string = "IP" + i;
            if (this.userProps.containsKey(string)) {
                this.m_ipaddressFields[i].setText(this.userProps.getProperty(string));
            }
            gridBagLayout.setConstraints(this.m_ipaddressFields[i], gridBagConstraints);
            sCTPanel2.add(this.m_ipaddressFields[i]);
        }
        sCTPanel.add((Component)sCTPanel2, "North");
        return sCTPanel;
    }

    private SCTPanel otherPanel() {
        String[] stringArray = new String[]{"Internal", "USB", "IEEE-1394"};
        this.m_otherCheckBoxes = new SCTRadioButton[3];
        ButtonGroup buttonGroup = new ButtonGroup();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        SCTLabel sCTLabel = new SCTLabel("Other");
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        for (int i = 0; i < this.m_otherCheckBoxes.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i + 2;
            this.m_otherCheckBoxes[i] = new SCTRadioButton(stringArray[i]);
            gridBagLayout.setConstraints(this.m_otherCheckBoxes[i], gridBagConstraints);
            buttonGroup.add(this.m_otherCheckBoxes[i]);
            sCTPanel2.add(this.m_otherCheckBoxes[i]);
        }
        sCTPanel.add((Component)sCTPanel2, "North");
        return sCTPanel;
    }

    private SCTPanel btnPanel() {
        SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
        SCTPanel sCTPanel2 = new SCTPanel(new FlowLayout(2));
        sCTPanel2.setBackground(SCTConstants.DIALOG_BG_COLOR);
        this.m_testButton = new SCTButton("Connect");
        this.m_testButton.addActionListener(this);
        sCTPanel2.add(this.m_testButton);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        sCTPanel.add((Component)jSeparator, "North");
        sCTPanel.add((Component)sCTPanel2, "Center");
        return sCTPanel;
    }

    private void setSerialPort() {
        for (int i = 0; i < this.m_serialCheckBoxes.length; ++i) {
            if (!this.m_serialCheckBoxes[i].isSelected()) continue;
            SerialConnection serialConnection = new SerialConnection(this.m_serialCheckBoxes[i].getText());
            SCTSelection.instance().setCurrentConnection((IRemoteConnection)serialConnection);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource() == this.m_testButton) {
            object = null;
            for (int i = 0; i < this.m_ethernetCheckBoxes.length; ++i) {
                String string = "IP" + i;
                this.userProps.put(string, this.m_ipaddressFields[i].getText());
                if (!this.m_ethernetCheckBoxes[i].isSelected()) continue;
                object = this.m_ipaddressFields[i].getText();
                SocketConnection socketConnection = new SocketConnection((String)object);
                SCTSelection.instance().setCurrentConnection((IRemoteConnection)socketConnection);
            }
            if (object == null) {
                MessageOptionPane.ShowMessage(this.getParent(), "You must first select a device to connect to.", "No item selected");
                return;
            }
            this.m_testButton.setEnabled(false);
            try {
                TEInterface.instance().scanInstrument();
                if (TEInterface.instance().m_instrument.isConnected()) {
                    MessageOptionPane.ShowMessage(this.getParent(), "Successfully scanned the instrument", "Success");
                    this.getMainWindow().setStatusPanelAttribute(3, "Connected to " + (String)object);
                } else {
                    MessageOptionPane.ShowMessage(this.getParent(), TEInterface.instance().m_instrument.getErrorMessage(), "Failure");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageOptionPane.ShowErrorMessage(this.getParent(), "Error connecting to the instrument, please restart and check your settings.", "Error");
                System.exit(0);
            }
        }
        try {
            object = new FileOutputStream("Properties.host.user");
            this.userProps.store((OutputStream)object, "---User IP Settings---");
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.setSerialPort();
            HostPortTestDialog hostPortTestDialog = new HostPortTestDialog(this.getMainWindow());
            hostPortTestDialog.setVisible(true);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

